//								EJEMPLO 32
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//Los mdulos CCPx. Modo de Comparacin. 
//
//El TMR1 cuenta tantos pulsos externos como se indique mediante los interruptores conectados a
//RA5-RA0. Cada vez que se alcanza el valor fijado, la salida RB0
//cambia de estado.
	
#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)
#use fast_io (C)
#use delay(clock=4000000)

#int_ccp1		//Vector de interrupcin del CCP1

//Programa de tratamiento de la interrupcin que provoca el mdulo CCP1 cada vez que el TMR1
//cuenta tantos pulsos externos como los prefijados mediante las entradas RA5-RA0.

tratamiento()	//Funcin de tratamiento del CCP1
{ 
	setup_timer_1(T1_DISABLED);	//T1 en OFF
	set_timer1(0);				//Reiniciar el TMR1
	output_b(input_b() ^ 0x01);	//RB0 cambia de estado
	setup_timer_1(T1_EXTERNAL | T1_DIV_BY_1);	//TMR1 en ON
}
	
main()
{  
	SETUP_ADC_PORTS(NO_ANALOGS);//Puerta A Digital
	output_b(0x00);				//Borra las salidas
	set_tris_a(0xff);			//Puerta A entrada
	set_tris_b(0x00);			//Puerta B salida
	set_tris_c(0xff);			//Puerta C entrada
	enable_interrupts(int_ccp1); //Activa interrupcin del CCP1

//El TMR1 acta en el modo contador de pulsos externos sensible al flanco ascendente y con
//un preescaler de 1:1. Estos pulsos pueden ser suministrador por el generador del laboratorio
//El mdulo CCP1 acta en modo de comparacin e interrupcin al coincidir

	setup_ccp1(CCP_COMPARE_INT);	//Mdulo CCP en modo comparacin	
	CCP_1=0;					//Puesta a 0 del latch CCP1
	set_timer1(0);				//Reiniciar el TMR1
	setup_timer_1(T1_EXTERNAL | T1_DIV_BY_1);	//TMR1 externo y preescaler de 1:1
	enable_interrupts(global);	//Habilita interrupciones

	while(1)
	{
		CCP_1=input_a()&0b00111111;	//Lee puerta A y carga el CCP1	
	}
}	
